import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;

/**
 * The purpose of the PlayerScoreCard is to contain, 
 * keep track, and display info of eachPlayer
 * 
 * @author Chris Thiel, OFMCap
 * @version 8 Jan 2013
 * @version 1 Mar 2023 bug fixes
 *
 */
public class PlayerScoreCard 
{
    private Player player;
    private int[] currentScore; // the scores of the current game
    private int total; //sum of all the scores of all the games
    private int zaps; //total number of times they went too far
    private int wins; //total number of wins so far
    private int gameCount;
    private Color scoreColor, winsColor, avgColor, zapsColor;
    private DecimalFormat df;

    public static final int  LEFT=50, WIDTH=425, HEIGHT=45, GAP=5;
    public PlayerScoreCard(Player p){
        this.player=p;
        currentScore=new int[5];
        for(int i=0; i<5; i++)
            currentScore[i]=0;
        total=0;
        zaps=0;
        wins=0;
        gameCount=0;
        resetColors();
        df=new DecimalFormat("#0.00");
    }
    public void initNewGame() {
        player.initNewGame();
        gameCount++;
        for(int i=0; i<5; i++)
            currentScore[i]=0;
    }
    public boolean isActive() {
        return player.isActive();
    }
    public void decide(int round, int roundTotal) {
        player.decide(round, roundTotal);
    }
    public void setScore(int round, int roundTotal) {
        player.setScore(round, roundTotal);
        currentScore[round-1] = roundTotal;
    }
    public int getCurrentGameTotal()
    {
            int tot=0;
            for (int s:currentScore)
                tot+=s;
            return tot;
    }
    public void setActive(boolean value) {
        player.setActive(value);
    }
    public void increaseZapCount() {
        this.zaps++;
    }
    public void recordGame() {
        this.total+=getCurrentGameTotal();
    }
    public void recordWin(){
        wins++;
        scoreColor=Color.yellow;
    }
    public void initNewRound() {
        player.initNewRound();

    }
    public void draw(Graphics g, int y) {
        g.setFont(new Font("Helvetica", Font.BOLD,  18));
        g.setColor(Color.BLACK);
        g.fillRect(LEFT, y, 425, HEIGHT); 
        g.fillRect(LEFT+430, y, HEIGHT, HEIGHT);
        g.fillRect(LEFT+430+50, y, 2*HEIGHT, HEIGHT);
        g.fillRect(LEFT+430+100+HEIGHT, y, 2*HEIGHT, HEIGHT);
        g.fillRect(LEFT+430+150+2*HEIGHT, y, 70, HEIGHT);

        g.setColor(scoreColor);
        g.fillRect(LEFT+GAP, y+GAP, WIDTH-2*GAP, HEIGHT-2*GAP);
        g.setColor(scoreColor);
        g.fillRect(LEFT+430+GAP, y+GAP, HEIGHT-2*GAP, HEIGHT-2*GAP);//score
        g.setColor(avgColor);
        g.fillRect(LEFT+430+50+GAP, y+GAP, 2*HEIGHT-2*GAP, HEIGHT-2*GAP);//avg
        g.setColor(zapsColor);
        g.fillRect(LEFT+430+100+GAP+HEIGHT, y+GAP, 2*HEIGHT-2*GAP, HEIGHT-2*GAP);//zaps
        g.setColor(winsColor);
        g.fillRect(LEFT+430+150+GAP+2*HEIGHT, y+GAP, 70-2*GAP, HEIGHT-2*GAP);//wins

        g.setColor(Color.BLACK);
        g.drawString(player.getName(), LEFT+4*GAP, y+2*HEIGHT/3);
        for(int i=0;i<5; i++)
            g.drawString(""+this.currentScore[i], LEFT+200+(i)*9*GAP, y+2*HEIGHT/3);
        g.drawString(""+this.getCurrentGameTotal(), LEFT+430+2*GAP, y+2*HEIGHT/3);

        if (gameCount>0){
            g.drawString(df.format((double)(total)/gameCount), LEFT+440+50+2*GAP, y+2*HEIGHT/3);
            g.drawString(df.format((double)(zaps)/gameCount), LEFT+445+100+2*GAP+HEIGHT, y+2*HEIGHT/3);
        }
        g.drawString(""+this.wins, LEFT+430+150+2*GAP+2*HEIGHT, y+2*HEIGHT/3);
    }
    public int getGameCount() {    
        return gameCount;
    }
    public void resetColors() {    
        scoreColor=winsColor=avgColor=zapsColor=Color.CYAN;
    }
    public int getZaps() {
        return zaps;
    }
    public int getTotal() {    
        return this.total;
    }
    public int getWins() {
        return this.wins;
    }
    public void setZapsColor(Color c) {
        zapsColor=c;
    }
    public void setWinsColor(Color c) {
        winsColor=c;
    }
    public void setAvgColor(Color c) {
        avgColor=c;
    }
    public String getName() {
        return player.getName();
    }
}
